dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 3, 270, 250, "assets/images/table/ballroom", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 6, 220, 400, "assets/images/table/ballroom_6", "assets/images/food/item_mark2", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 0;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(uncle);
guest.matchType = female01;
guest.percentRequestCoffee = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female01;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 3, 3000);

-- Group 2

guest = LManager.GenGuest(female03);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(4, 5, 20000);

-- Group 3

guest = LManager.GenGuest(uncle);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(6, 6, 30000);

-- Group 3


guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 8, 40000);


-- Group 4

guest = LManager.GenGuest(uncle);
guest.matchType = aunt;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 10, 60000);

--  Group 6

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(11, 14, 100000);


-- Group 7

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 17, 130000);




LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("speakerDelay", 110000); 
LManager:SetLevelSetting ("speakerChance", 20);

LManager:SetLevelSetting ("bridesmaidsDelay", 70000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);


LManager:SetLevelSetting ("blaster", 0);


-- Set up the Level Settings
LManager:SetLevelNumber(2,3);
LManager:SetLevelScores(6400, 8000);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/new_dance_4.ogg", "assets/audio/music/Dance Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_ballroom");
LManager:SetChairImage("assets/images/table/chair02");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );